-------------------------------------------------------------------------------
-- File: 		idt70V657.vhdl
-- Description: 	IDT Asynchronous Dual-Port RAM 32768 x 36
-- Generated on:	Mon 3/13/2000 18:4:13
-- Revision:    1.1 Qualified a_busy & b_busy with a_ce & b_ce  TH 9/7/04
-------------------------------------------------------------------------------
-- INTEGRATED DEVICE TECHNOLOGY, INC

-- LICENSE TERMS AND CONDITIONS

-- READ THE TERMS AND CONDITIONS OF THIS AGREEMENT CAREFULLY.  BY COPYING OR
-- USING THIS FILE, INFORMATION,  DATA OR SOFTWARE YOU ARE ACCEPTING AND
-- AGREEING TO THE TERMS OF THIS AGREEMENT BETWEEN YOU ("LICENSEE") AND
-- INTEGRATED DEVICE TECHNOLOGY, INC. ("IDT").

-- License Grant. IDT grants to Licensee a personal, royalty free non-exclusive,
-- non-transferable,  license for the term of this Agreement, to use the file,
-- information, data and software provided herein ("Code"), solely for the
-- purpose of testing and verifying the operation, and/or behavior of IDT
-- products, and solely for the purpose of developing products which incorporate
-- IDT products, without any rights to license, sub-license or distribute the
-- Code, or IDT products or derivatives thereof.

-- Copies. The Code and IDT products are copyrighted and otherwise protected by
-- law.  Licensee can make only 6 copies, for internal use only, and only in
-- accordance with the terms and conditions of this Agreement. Each electronic
-- reproduction of the Code constitutes a separate copy. All proprietary notices
-- incorporated in, marked on or fixed to the IDT products or Code by IDT or its
-- suppliers shall be duplicated by Licensee on all copies and derivatives.
-- Licensee must not assign, license, lease, rent, loan, sell or otherwise
-- dispose of the Code or derivatives on a temporary or permanent basis.

-- Reservation. This Agreement grants Licensee a license to the Code only, and
-- only such rights as are specifically enumerated herein. No other right, title
-- or interest in the Code or IDT products is hereby conveyed to Licensee.
-- Licensee acknowledges that all rights, title and interest to the Code is and
-- remains with IDT.

-- Reverse Engineering. Licensee agrees that it will not reverse engineer,
-- reverse compile, disassemble IDT products or the Code or otherwise attempt to
-- create source code which is derived from the Code or portions of IDT products
-- which were delivered to Licensee in binary form.

-- DISCLAIMER OF WARRANTY. THE CODE AND/OR PRODUCTS PROVIDED PURSUANT TO THIS
-- AGREEMENT ARE PROVIDED "AS IS" WITH ALL FAULTS. IDT DOES NOT WARRANT THAT THE
-- OPERATION OF THE CODE OR OPERATION OR BEHAVIOR OF IDT PRODUCTS WILL BE AS
-- TESTED OR MODELED, WILL BE  UNINTERRUPTED OR ERROR FREE OR THAT ANY PROBLEMS
-- IDENTIFIED WILL BE CORRECTED. IDT DISCLAIMS ANY AND ALL WARRANTIES FOR THE
-- CODE, FOR IDT PRODUCTS OR ANY LICENSEE PRODUCTS CREATED THEREWITH, WHETHER
-- EXPRESS OR IMPLIED, INCLUDING (WITHOUT LIMITATION) ANY WARRANTIES OF
-- MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  EXCEPT FOR THE
-- STATUTORY WARRANTIES OF TITLE, THERE ARE NO EXPRESS OR IMPLIED WARRANTIES.
-- THE ENTIRE RISK ARISING OUT OF USE OF THE CODE AND ANY PRODUCTS RESULTING
-- THEREFROM IS AND REMAINS WITH COMPANY.

-- Title. Title to the Code and IDT products, including all know how and all
-- proprietary rights shall at all times remain with IDT. Licensee has no
-- ownership of the Code or IDT products other than ownership of the physical
-- media.

-- Copyright. A copyright notice on the IDT Products does not, by itself,
-- constitute evidence of publication or public disclosure.

-- Term. The term of this Agreement shall be ten years from the date IDT ships
-- the Code to Licensee. Either party may extend the term of this Agreement for
-- an additional one year period by written notice to the other party ninety
-- (90) days prior to the expiration of the Agreement. Upon expiration or
-- termination of this Agreement for any reason, Licensee shall immediately
-- return to IDT or destroy all copies of the Code.  IDT, AT ITS OPTION, MAY
-- TERMINATE THIS LICENSE, UPON 7 DAYS NOTICE, IF LICENSEE USES, DISCLOSES,
-- COPIES OR MODIFIES THE CODE EXCEPT AS EXPRESSLY PERMITTED IN THIS AGREEMENT.
-- IDT'S LIMITATION OF LIABILITY SURVIVES TERMINATION OF THIS AGREEMENT.

-- Export Controls. Before exporting or re-exporting any IDT Products, Licensee
-- shall: (a) fully comply with all U.S. export control laws and regulations,
-- and (b) take reasonable precautions, including seeking the advice of foreign
-- legal counsel where necessary, to protect the proprietary rights of IDT and
-- its suppliers in each foreign country in which the IDT Products are to be
-- used.

-- Disclaimer of Liability. IN NO EVENT SHALL IDT BE LIABLE BE LIABLE FOR ANY
-- DAMAGES ARISING OUT OF RELATING TO THIS AGREEMENT, INCLUDING, WITHOUT
-- LIMITATION, DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR EXEMPLARY DAMAGES,
-- HOWEVER CAUSED OR ON ANY THEORY OF LIABILITY, WHETHER CONTRACT, STRICT
-- LIABILITY OR TORT, EVEN IF IDT HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
-- DAMAGE AND NOTWITHSTANDING THE FAILURE OF ESSENTIAL PURPOSE OF ANY REMEDY.

-- Government Use. Licensee shall not, without the prior written consent of IDT,
-- deliver the Code, IDT Products, any portion thereof, or any technical data
-- relating thereto, to any branch or agency of the United States Government
-- without a written predetermination that such items will be protected by
-- limited or restricted rights as set forth in DOD FAR52.227.7013 or the
-- equivalent governmental rule or regulation.

-- Governing Law. This license is made in and shall be governed by the laws of
-- the State of California, excluding its conflict of laws rules, Jurisdiction
-- and venue for all claims or disputes arising under this Agreement shall be in
-- either the Superior and Municipal Courts for the State of California for
-- Santa Clara County, or the United States District Court for the Northern
-- District of California, San Jose Division.

-- Attorneys Fees. In the event of any dispute resolution proceeding between the
-- parties, the prevailing party shall be entitled to recover its costs and
-- reasonable attorneys fees.

-- Assignment. Licensee shall not assign or transfer this Agreement nor any
-- right or license hereunder without the prior written consent of IDT, and any
-- assignment permitted shall be subject to the written consent of the assignee
-- to all the terms of this Agreement.

-- Equitable Relief. Licensee acknowledges that damages may not be an adequate
-- remedy for breach of the provisions of this Agreement, and that equitable
-- relief, including injunctive relief, is authorized in addition to any other
-- legal or damages remedy.

-- Severability. If any court of competent jurisdiction shall declare any
-- provision of this License void or unenforceable, such declaration shall have
-- no effect on the remaining terms hereof.

-- Confidentiality. Licensee acknowledges that the Code is confidential and
-- proprietary to IDT.  Licensee shall use the Code only for the licensed
-- purpose set forth above.  Licensee may not transfer or disclose the Code or
-- information derived therefrom to any person or entity. A breach of this
-- confidentiality obligations entitles IDT to terminate this Agreement and to
-- resort to all other remedies available by law.

-- BY ELECTRONICALLY AGREEING TO THIS AGREEMENT YOU ACKNOWLEDGE THAT YOU HAVE
-- READ THIS AGREEMENT, UNDERSTAND IT, AND AGREE TO BE BOUND BY ITS TERMS AND
-- CONDITIONS.  YOU FURTHER AGREE THAT IT IS THE COMPLETE AND EXCLUSIVE
-- STATEMENT OF THE AGREEMENT BETWEEN YOU AND IDT, AND SUPERSEDES ANY PROPOSAL
-- OR PRIOR AGREEMENT, ORAL OR WRITTEN, AND ANY OTHER COMMUNICATIONS BETWEEN YOU
-- AND IDT RELATING TO THE SUBJECT MATTER OF THIS AGREEMENT.
-------------------------------------------------------------------------------


library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.numeric_std.all;

entity idt70V657 is
  generic (
    ADDR_WIDTH: integer := 15;
    PORT_WIDTH: integer := 36;
    PART_DEPTH: integer := 32768);

  port ( A_IO, B_IO         	: inout std_logic_vector (PORT_WIDTH-1 downto 0);
	 B_AP, A_AP	    	: in std_logic_vector (ADDR_WIDTH-1 downto 0);
	 A_BE0XP, A_BE1XP, 
	 A_BE2XP, A_BE3XP, 
	 A_CE0XP, A_CE1P,
	 A_OEXP, A_OPTIONP, 
	 A_RWXP, A_SEMXP, A_VDDQ, 
	 B_BE0XP, B_BE1XP, 
	 B_BE2XP, B_BE3XP, 
	 B_CE0XP, B_CE1P, 
	 B_OEXP, B_OPTIONP, 
	 B_RWXP, B_SEMXP, B_VDDQ, 
	 MSXP, TCKP, TDIP, 
	 TESTP, TMSP, TRSTXP 	: in std_ulogic;
         A_INTXP, B_INTXP, TDOP : out std_ulogic;
         A_BUSYXP, B_BUSYXP 	: inout std_ulogic );

  -- constant tskew: time := 1 ns;
  subtype word is std_logic_vector(PORT_WIDTH-1 downto 0);
  type ram_type is array(PART_DEPTH-1 downto 0) of word;
end idt70V657;


architecture behavioral of idt70V657 is
  signal a_dout, b_dout	: std_logic_vector (PORT_WIDTH-1 downto 0);
  signal a_ce, b_ce	: std_ulogic;
  signal a_sem, b_sem	: std_ulogic;
  signal a_semreqx, 
	 b_semreqx	: std_logic_vector (7 downto 0);
  signal a_grantx, 
	 b_grantx	: std_logic_vector (7 downto 0);
  signal a_semout, 
	 b_semout	: std_logic_vector (PORT_WIDTH-1 downto 0);
  signal a_busy, b_busy	: std_ulogic;
  signal a_blwr, b_blwr	: std_ulogic;
  signal a_read, b_read	: std_ulogic;
  signal a_write, b_write
			: std_ulogic;
  signal a_rec, b_rec	: std_ulogic;
  signal poweron	: std_ulogic;
begin

  -- Internal Chip Enable
  a_ce <= not A_CE0XP and A_CE1P;
  b_ce <= not B_CE0XP and B_CE1P;
  -- Internal Semaphore
  a_sem <= not a_ce and not A_SEMXP;
  b_sem <= not b_ce and not B_SEMXP;
  -- Internal Read 
  a_read <= a_ce and A_RWXP;
  b_read <= b_ce and B_RWXP;

  -- Internal Busy and Write Blocking 
  Busy: process ( A_AP, B_AP, a_ce, b_ce )
  begin
    if ( (a_ce = '1') and (b_ce = '1') and (A_AP = B_AP) and (A_AP'event or a_ce'event) ) then
      a_busy <= '1';	-- Set A_BUSY
    else
      a_busy <= '0';	-- Clear A_BUSY
    end if;
    if ( (b_ce = '1') and (a_ce = '1') and (A_AP = B_AP) and (B_AP'event or b_ce'event) ) then
      b_busy <= '1';	-- Set B_BUSY
    else
      b_busy <= '0';	-- Clear B_BUSY
    end if;
  end process Busy;

  -- Internal Write Blocking
  -- Master mode use internal busy; Slave mode use external busy
  a_blwr <= a_busy when ( MSXP = '1' ) else not A_BUSYXP;
  b_blwr <= b_busy when ( MSXP = '1' ) else not B_BUSYXP;

  -- Internal Write
  a_write <= a_ce and not A_RWXP and not a_blwr;
  b_write <= b_ce and not B_RWXP and not b_blwr;

  -- Interrupt Clearing, blocked by blwr
  a_rec <= a_ce and not A_OEXP and not a_blwr;
  b_rec <= b_ce and not B_OEXP and not b_blwr;


  -- Write/Read data
  write_read_data: process ( a_write, b_write, a_read, b_read,
				A_IO, B_IO, A_AP, B_AP,
				A_BE0XP, A_BE1XP, A_BE2XP, A_BE3XP,
				B_BE0XP, B_BE1XP, B_BE2XP, B_BE3XP )
    variable mem	: ram_type;
  begin
    if a_write = '1' then
      if A_BE0XP = '0' then
	mem(to_integer(unsigned(A_AP)))(8 downto 0) := A_IO(8 downto 0);
      end if;
      if A_BE1XP = '0' then
	mem(to_integer(unsigned(A_AP)))(17 downto 9) := A_IO(17 downto 9);
      end if;
      if A_BE2XP = '0' then
	mem(to_integer(unsigned(A_AP)))(26 downto 18) := A_IO(26 downto 18);
      end if;
      if A_BE3XP = '0' then
	mem(to_integer(unsigned(A_AP)))(35 downto 27) := A_IO(35 downto 27);
      end if;
    end if;

    if b_write = '1' then
      if B_BE0XP = '0' then
	mem(to_integer(unsigned(B_AP)))(8 downto 0) := B_IO(8 downto 0);
      end if;
      if B_BE1XP = '0' then
	mem(to_integer(unsigned(B_AP)))(17 downto 9) := B_IO(17 downto 9);
      end if;
      if B_BE2XP = '0' then
	mem(to_integer(unsigned(B_AP)))(26 downto 18) := B_IO(26 downto 18);
      end if;
      if B_BE3XP = '0' then
	mem(to_integer(unsigned(B_AP)))(35 downto 27) := B_IO(35 downto 27);
      end if;
    end if;

    if a_read = '1' then
      if A_BE0XP = '0' then
	a_dout(8 downto 0) <= mem(to_integer(unsigned(A_AP)))(8 downto 0);
      else 
	a_dout(8 downto 0) <= "ZZZZZZZZZ";
      end if;
      if A_BE1XP = '0' then
	a_dout(17 downto 9) <= mem(to_integer(unsigned(A_AP)))(17 downto 9);
      else 
	a_dout(17 downto 9) <= "ZZZZZZZZZ";
      end if;
      if A_BE2XP = '0' then
	a_dout(26 downto 18) <= mem(to_integer(unsigned(A_AP)))(26 downto 18);
      else 
	a_dout(26 downto 18) <= "ZZZZZZZZZ";
      end if;
      if A_BE3XP = '0' then
	a_dout(35 downto 27) <= mem(to_integer(unsigned(A_AP)))(35 downto 27);
      else 
	a_dout(35 downto 27) <= "ZZZZZZZZZ";
      end if;
    end if;

    if b_read = '1' then
      if B_BE0XP = '0' then
	b_dout(8 downto 0) <= mem(to_integer(unsigned(B_AP)))(8 downto 0);
      else
	b_dout(8 downto 0) <= "ZZZZZZZZZ";
      end if;
      if B_BE1XP = '0' then
	b_dout(17 downto 9) <= mem(to_integer(unsigned(B_AP)))(17 downto 9);
      else
	b_dout(17 downto 9) <= "ZZZZZZZZZ";
      end if;
      if B_BE2XP = '0' then
	b_dout(26 downto 18) <= mem(to_integer(unsigned(B_AP)))(26 downto 18);
      else
	b_dout(26 downto 18) <= "ZZZZZZZZZ";
      end if;
      if B_BE3XP = '0' then
	b_dout(35 downto 27) <= mem(to_integer(unsigned(B_AP)))(35 downto 27);
      else
	b_dout(35 downto 27) <= "ZZZZZZZZZ";
      end if;
    end if;
  end process write_read_data;

  -- IO Assignment during read
  A_IO <= a_dout when ( (a_read = '1') and (A_OEXP = '0') ) else 
	a_semout when ( (a_sem = '1') and (A_RWXP = '1') 
			and (A_OEXP = '0') ) else 
	"ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ";
  B_IO <= b_dout when ( (b_read = '1') and (B_OEXP = '0') ) else 
	b_semout when ( (b_sem = '1') and (B_RWXP = '1') 
			and (B_OEXP = '0') ) else 
	"ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ";


  -- BUSY Outputs
  A_BUSYXP <= not a_busy when ( MSXP = '1' ) else 'Z';
  B_BUSYXP <= not b_busy when ( MSXP = '1' ) else 'Z';
  

  -- Power-on
  poweron <= A_VDDQ and B_VDDQ;

  -- Interrupt Function
  Interrupt: process ( a_rec, b_rec, a_write, b_write, 
			A_AP'delayed(1 ns), B_AP'delayed(1 ns), poweron )
  begin
    if ( poweron = '1' and poweron'event ) then
      A_INTXP <= '1';
      B_INTXP <= '1';
    end if;

    if ( b_write = '1' and B_AP = "111111111111110" ) then
      A_INTXP <= '0';
    end if;
    if ( a_write = '1' and A_AP = "111111111111111" ) then
      B_INTXP <= '0';
    end if;

    if ( a_rec = '1' and A_AP = "111111111111110" ) then
      A_INTXP <= '1';
    end if;
    if ( b_rec = '1' and B_AP = "111111111111111" ) then
      B_INTXP <= '1';
    end if;
  end process Interrupt;


  -- Semaphore Functions
  Semaphore_request: process ( a_sem, b_sem, A_AP, B_AP, A_IO, B_IO, 
			A_RWXP, B_RWXP, poweron )
  begin
    if ( poweron = '1' and poweron'event ) then
      a_semreqx (7 downto 0) <= "11111111";
      b_semreqx (7 downto 0) <= "11111111";
    end if;

    if ( a_sem = '1' and A_RWXP = '0' ) then
      a_semreqx(to_integer(unsigned(A_AP(2 downto 0)))) <= A_IO(0);
    end if;

    if ( b_sem = '1' and B_RWXP = '0' ) then
      b_semreqx(to_integer(unsigned(B_AP(2 downto 0)))) <= B_IO(0);
    end if;
  end process Semaphore_request;


  Semaphore_grantA: process ( a_semreqx, b_grantx, poweron )
  begin
    if ( poweron = '1' ) then 
      if ( poweron'event ) then
	a_grantx (7 downto 0) <= "11111111";
      end if;

      for i in 0 to 7 loop
	if ( b_grantx(i) = '0' ) then
	  a_grantx(i) <= '1';
	else
	  a_grantx(i) <= a_semreqx(i);
	end if; 
      end loop;
    end if;
  end process Semaphore_grantA;

  Semaphore_grantB: process ( b_semreqx, a_grantx, poweron )
  begin
    if ( poweron = '1' ) then
      if ( poweron'event ) then
	b_grantx (7 downto 0) <= "11111111";
      end if;

      for i in 0 to 7 loop
	if ( a_grantx(i) = '0' ) then
	  b_grantx(i) <= '1';
	else
	  b_grantx(i) <= b_semreqx(i);
	end if;
      end loop;
    end if;
  end process Semaphore_grantB;


  Semaphore_outA: process ( a_sem, A_AP, A_RWXP, A_OEXP )
  begin
    if ( a_sem = '1' and A_RWXP = '1' and A_OEXP = '0' ) then
      for i in 0 to A_IO'length-1 loop
	a_semout(i) <= a_grantx(to_integer(unsigned(A_AP(2 downto 0))));
      end loop;
    end if;
  end process Semaphore_outA;

  Semaphore_outB: process ( b_sem, B_AP, B_RWXP, B_OEXP )
  begin
    if ( b_sem = '1' and B_RWXP = '1' and B_OEXP = '0' ) then
      for i in 0 to B_IO'length-1 loop
	b_semout(i) <= b_grantx(to_integer(unsigned(B_AP(2 downto 0))));
      end loop;
    end if;
  end process Semaphore_outB;


end behavioral;

