// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file JointTrajectory.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "JointTrajectory.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool JointTrajectory_serialize_topic(ucdrBuffer* writer, const JointTrajectory* topic)
{
    (void) Header_serialize_topic(writer, &topic->header);
    (void) ucdr_serialize_uint32_t(writer, topic->joint_names_size);
    for(int i = 0; i < topic->joint_names_size; ++i)
    {
        (void) ucdr_serialize_string(writer, topic->joint_names[i]);
    }

    (void) ucdr_serialize_uint32_t(writer, topic->points_size);
    for(int i = 0; i < topic->points_size; ++i)
    {
        (void) JointTrajectoryPoint_serialize_topic(writer, &topic->points[i]);
    }

    return !writer->error;
}

bool JointTrajectory_deserialize_topic(ucdrBuffer* reader, JointTrajectory* topic)
{
    (void) Header_deserialize_topic(reader, &topic->header);
    (void) ucdr_deserialize_uint32_t(reader, &topic->joint_names_size);
    if(topic->joint_names_size > 100)
    {
        reader->error = true;
    }
    else
    {
        for(int i = 0; i < topic->joint_names_size; ++i)
        {
            (void) ucdr_deserialize_string(reader, topic->joint_names[i], 255);
        }
    }

    (void) ucdr_deserialize_uint32_t(reader, &topic->points_size);
    if(topic->points_size > 100)
    {
        reader->error = true;
    }
    else
    {
        for(int i = 0; i < topic->points_size; ++i)
        {
            (void) JointTrajectoryPoint_deserialize_topic(reader, &topic->points[i]);
        }
    }

    return !reader->error;
}

uint32_t JointTrajectory_size_of_topic(const JointTrajectory* topic, uint32_t size)
{
    uint32_t previousSize = size;
    size += Header_size_of_topic(&topic->header, size);
    size += ucdr_alignment(size, 4) + 4;
    for(int i = 0; i < topic->joint_names_size; ++i)
    {
        size += ucdr_alignment(size, 4) + 4 + (uint32_t)strlen(topic->joint_names[i]) + 1;
    }

    size += ucdr_alignment(size, 4) + 4;
    for(int i = 0; i < topic->points_size; ++i)
    {
        size += JointTrajectoryPoint_size_of_topic(&topic->points[i], size);
    }

    return size - previousSize;
}
