/***********************************************************************/
/*                                                                     */
/*  FILE        :lowsrc.c                                              */
/*  DATE        :Mon, Aug 17, 2009                                     */
/*  DESCRIPTION :Program of I/O Stream                                 */
/*  CPU TYPE    :H8SX/1527                                             */
/*                                                                     */
/*  This file is generated by Renesas Project Generator (Ver.4.13).    */
/*                                                                     */
/***********************************************************************/
                  



#include <string.h>
#include <stdio.h>
#include <stddef.h>
#include "typedefine.h"
#include "lowsrc.h"

_SINT open(_SBYTE *name, _SINT mode, _SINT flg);
_SINT close(_SINT fileno);
_SINT read(_SINT fileno, _SBYTE *buf, _UINT count);
_SINT write(_SINT fileno, _SBYTE *buf, _UINT count);
_SDWORD lseek(_SINT fileno, _SDWORD offset, _SINT base);
void _INIT_IOLIB(void);
void _CLOSEALL(void);


/* t@Cԍ */

#define STDIN  0        /* W      iR\[j */
#define STDOUT 1        /* Wo      iR\[j */
#define STDERR 2        /* WG[óiR\[j */

#define FLMIN  0               /* ŏ̃t@Cԍ */
#define FLMAX  (IOSTREAM-1)    /* ő̃t@Cԍ */

/* t@C̃tO */

#define O_RDONLY 0x0001     /* ǂݍݐp */
#define O_WRONLY 0x0002     /* op */
#define O_RDWR   0x0004     /* ǂݏp */

/* ꕶR[h */

#define CR 0x0d     /* A     */
#define LF 0x0a     /* s     */

const _SINT _nfiles = IOSTREAM;
struct _iobuf _iob[IOSTREAM];
_UBYTE sml_buf[IOSTREAM];


/*************************************************************************/
/* QƊ֐̐錾F                                                      */
/* V~[^EfobKŃR\[ւ̕o͂s                */
/*   AZuvO̎Q                                          */
/*************************************************************************/
extern void charput(_SBYTE);     /* ꕶo͏     */
extern _SBYTE charget(void);     /* ꕶ͏     */

/*************************************************************************/
/* ÓIϐ̒`F                                                      */
/* ᐅC^tF[X[`ŎgpÓIϐ̒`                  */
/*************************************************************************/
_SBYTE flmod[IOSTREAM];      /* I[vt@C̃[hݒꏊ  */

/*************************************************************************/
/*  open:t@C̃I[v                                              */
/*        ^[lFt@Cԍij                               */
/*                    -1          isj                               */
/*************************************************************************/
_SINT open(_SBYTE *name,               /* t@C         */
     _SINT  mode,                      /* t@C̃[h   */
     _SINT  flg)                       /* gp             */
{
       /* t@Cɏ]ă[h`FbNAt@CԍԂ */

       if(strcmp(name,"stdin")==0){          /* W̓t@C   */
             if((mode&O_RDONLY)==0){
                      return -1;
             }
             flmod[STDIN] = mode;
             return STDIN;
       }

       else if(strcmp(name,"stdout")==0){   /* Wo̓t@C */
             if((mode&O_WRONLY)==0){
                      return -1;
             }
             flmod[STDOUT] = mode;
             return STDOUT;
       }

       else if(strcmp(name,"stderr")==0){   /* WG[o̓t@C */
             if((mode&O_WRONLY)==0){
                      return -1;
             }
             flmod[STDERR] = mode;
             return STDERR;
       }

       else {
             return -1;     /* G[ */
       }
}

/*************************************************************************/
/*  close:t@C̃N[Y                                             */
/*       ^[lF0          ij                                 */
/*                   -1         isj                                 */
/*************************************************************************/
_SINT close(_SINT fileno)              /* t@Cԍ */
{
       if((fileno<FLMIN) || (FLMAX<fileno)){ /* t@Cԍ͈̔̓`FbN */
             return -1;
       }
       flmod[fileno] = 0;              /* t@C̃[hZbg */
       return 0;
}

/*************************************************************************/
/*  read:f[^̓ǂݍ                                                */
/*        ^[lFۂɓǂݍ񂾕 ij                    */
/*        		      -1 isj                                        */
/*************************************************************************/
_SINT read(_SINT fileno,          /* t@Cԍ           */
     _SBYTE *buf,                 /* ]obt@AhX */
     _UINT count)                 /* ǂݍݕ         */
{
       _UINT i;

       /* t@Cԍɏ]ă[h`FbNAꕶÂ͂ăobt@Ɋi[ */

       if((flmod[fileno]&O_RDONLY) || (flmod[fileno]&O_RDWR)){
             for(i = count; i > 0u; i--){
                   *buf = charget();
                   if(*buf==CR){              /* s̒u */
                         *buf = LF;
                   }
                   buf++;
             }
             return count;
       }
       else {
             return -1;
       }
}
 
/*************************************************************************/
/*  write:f[^̏o                                               */
/*  	^[lFۂɏo  ij                     */
/*  		        -1  isj                                         */
/*************************************************************************/
_SINT write(_SINT fileno,              /* t@Cԍ           */
     _SBYTE *buf,                      /* ]obt@AhX */
     _UINT count)                      /* o         */
{
       _UINT i;
       _SBYTE c;

       /* t@Cԍɏ]ă[h`FbNAꕶÂo */

       if((flmod[fileno]&O_WRONLY) || (flmod[fileno]&O_RDWR)){
             for(i = count; i > 0u; i--){
                   c = *buf++;
                   charput(c);
             }
             return count;
       }
       else {
             return -1;
       }
}

/******************************************************************************/
/*  lseek:t@C̓ǂݍ݁^oʒu̐ݒ                              */
/*    ^[lFǂݍ݁^oʒũt@C擪̃ItZbgij*/
/*                -1  isj                                                */
/*      (R\[o͂ł́Alseek̓T|[gĂ܂)                   */
/******************************************************************************/
_SDWORD lseek(_SINT fileno,            /* t@Cԍ           */
       _SDWORD offset,                 /* ǂݍ݁^oʒu */
       _SINT base)                     /* ItZbg̋N_       */
{
       return -1L;
}

/****************************************************************************/
/* _INIT_IOLIB                                                              */
/****************************************************************************/
void _INIT_IOLIB(void)
{
       FILE *fp;

       for(fp = _iob; fp < _iob+_nfiles; fp++){
             fp->_bufptr = NULL;
             fp->_bufcnt = 0L;
             fp->_buflen = 0L;
             fp->_bufbase = NULL;
             fp->_ioflag1 = 0;
             fp->_ioflag2 = 0;
             fp->_iofd = 0;
       }

       if(freopen("stdin", "r", stdin)==NULL){
             stdin->_ioflag1 = 0xff;
       }
       stdin->_ioflag1 |= _IOUNBUF;

       if(freopen("stdout", "w", stdout)==NULL){
             stdout->_ioflag1 = 0xff;
       }
       stdout->_ioflag1 |= _IOUNBUF;

       if(freopen("stderr", "w", stderr)==NULL){
             stderr->_ioflag1 = 0xff;
       }
       stderr->_ioflag1 |= _IOUNBUF;
}

/****************************************************************************/
/* _CLOSEALL                                                                */
/****************************************************************************/
void _CLOSEALL(void)
{
       _SINT i;

       for(i = 0; i < _nfiles; i++){
             if(_iob[i]._ioflag1 & (_IOREAD | _IOWRITE | _IORW )){
                   fclose(&_iob[i]);
             }
       }
}
