/***********************************************************************/
/*                                                                     */
/*  FILE        :iodefine.h                                            */
/*  DATE        :Mon, Aug 17, 2009                                     */
/*  DESCRIPTION :Definition of I/O Register                            */
/*  CPU TYPE    :H8SX/1527                                             */
/*                                                                     */
/*  This file is generated by Renesas Project Generator (Ver.4.13).    */
/*                                                                     */
/***********************************************************************/
                  



/************************************************************************/
/*      H8SX/1520 Group Include File                       Ver 2.2      */
/************************************************************************/
struct st_hcan {                                        /* struct HCAN  */
               union {                                  /* MCR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char SLPMR:1;      /*    SLPMR     */
                            unsigned char      :1;      /*              */
                            unsigned char SLPM :1;      /*    SLPM      */
                            unsigned char      :2;      /*              */
                            unsigned char MTM  :1;      /*    MTM       */
                            unsigned char HLTRQ:1;      /*    HLTRQ     */
                            unsigned char RSTRQ:1;      /*    RSTRQ     */
                            }      BIT;                 /*              */
                     }          MCR;                    /*              */
               union {                                  /* GSR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char     :4;       /*              */
                            unsigned char RSB :1;       /*    RSB       */
                            unsigned char MTSF:1;       /*    MTSF      */
                            unsigned char TRWF:1;       /*    TRWF      */
                            unsigned char BOF :1;       /*    BOF       */
                            }      BIT;                 /*              */
                     }          GSR;                    /*              */
               union {                                  /* BCR          */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char SJW  :2;      /*    SJW       */
                            unsigned char BRP  :6;      /*    BRP       */
                            unsigned char BSP  :1;      /*    BSP       */
                            unsigned char TSEG2:3;      /*    TSEG2     */
                            unsigned char TSEG1:4;      /*    TSEG1     */
                            }     BIT;                  /*              */
                     }          BCR;                    /*              */
               union {                                  /* MBCR         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char     :1;       /*              */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          MBCR;                   /*              */
               union {                                  /* TXPR         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char     :1;       /*              */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          TXPR;                   /*              */
               union {                                  /* TXCR         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char     :1;       /*              */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          TXCR;                   /*              */
               union {                                  /* TXACK        */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char     :1;       /*              */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          TXACK;                  /*              */
               union {                                  /* ABACK        */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char     :1;       /*              */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          ABACK;                  /*              */
               union {                                  /* RXPR         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char MB0 :1;       /*    MB0       */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          RXPR;                   /*              */
               union {                                  /* RFPR         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char MB0 :1;       /*    MB0       */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          RFPR;                   /*              */
               union {                                  /* IRR          */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char OLFIF:1;      /*    OLFIF     */
                            unsigned char BOFIF:1;      /*    BOFIF     */
                            unsigned char EPIF :1;      /*    EPIF      */
                            unsigned char ROWIF:1;      /*    ROWIF     */
                            unsigned char TOWIF:1;      /*    TOWIF     */
                            unsigned char RFRIF:1;      /*    RFRIF     */
                            unsigned char RMIF :1;      /*    RMIF      */
                            unsigned char RSTIF:1;      /*    RSTIF     */
                            unsigned char      :3;      /*              */
                            unsigned char BOIF :1;      /*    BOIF      */
                            unsigned char      :2;      /*              */
                            unsigned char URIF :1;      /*    URIF      */
                            unsigned char MBEIF:1;      /*    MBEIF     */
                            }     BIT;                  /*              */
                     }          IRR;                    /*              */
               union {                                  /* MBIMR        */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char MB0 :1;       /*    MB0       */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          MBIMR;                  /*              */
               union {                                  /* IMR          */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char OLFIM:1;      /*    OLFIM     */
                            unsigned char BOFIM:1;      /*    BOFIM     */
                            unsigned char EPIM :1;      /*    EPIM      */
                            unsigned char ROWIM:1;      /*    ROWIM     */
                            unsigned char TOWIM:1;      /*    TOWIM     */
                            unsigned char RFRIM:1;      /*    RFRIM     */
                            unsigned char RMIM :1;      /*    RMIM      */
                            unsigned char      :1;      /*              */
                            unsigned char      :3;      /*              */
                            unsigned char BOIM :1;      /*    BOIM      */
                            unsigned char      :2;      /*              */
                            unsigned char URIM :1;      /*    URIM      */
                            unsigned char MBEIM:1;      /*    MBEIM     */
                            }     BIT;                  /*              */
                     }          IMR;                    /*              */
               unsigned char    REC;                    /* REC          */
               unsigned char    TEC;                    /* TEC          */
               union {                                  /* UMSR         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char MB7 :1;       /*    MB7       */
                            unsigned char MB6 :1;       /*    MB6       */
                            unsigned char MB5 :1;       /*    MB5       */
                            unsigned char MB4 :1;       /*    MB4       */
                            unsigned char MB3 :1;       /*    MB3       */
                            unsigned char MB2 :1;       /*    MB2       */
                            unsigned char MB1 :1;       /*    MB1       */
                            unsigned char MB0 :1;       /*    MB0       */
                            unsigned char MB15:1;       /*    MB15      */
                            unsigned char MB14:1;       /*    MB14      */
                            unsigned char MB13:1;       /*    MB13      */
                            unsigned char MB12:1;       /*    MB12      */
                            unsigned char MB11:1;       /*    MB11      */
                            unsigned char MB10:1;       /*    MB10      */
                            unsigned char MB9 :1;       /*    MB9       */
                            unsigned char MB8 :1;       /*    MB8       */
                            }     BIT;                  /*              */
                     }          UMSR;                   /*              */
               union {                                  /* LAFML        */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Byte Access */
                            unsigned char L;            /*    Low       */
                            unsigned char H;            /*    High      */
                            }     BYTE;                 /*              */
                     }          LAFML;                  /*              */
               union {                                  /* LAFMH        */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Byte Access */
                            unsigned char L;            /*    Low       */
                            unsigned char H;            /*    High      */
                            }     BYTE;                 /*              */
                     }          LAFMH;                  /*              */
               unsigned char    MC[16][8];              /* MC[x][y]     */
               char             wk1[16];                /*              */
               unsigned char    MD[16][8];              /* MD[x][y]     */
               char             wk2[16];                /*              */
               union {                                  /* MON          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :1;      /*              */
                            unsigned char TxSTP:1;      /*    TxSTP     */
                            unsigned char HCANE:1;      /*    HCANE     */
                            unsigned char      :3;      /*              */
                            unsigned char TxD  :1;      /*    TxD       */
                            unsigned char RxD  :1;      /*    RxD       */
                            }     BIT;                  /*              */
                     }          MON;                    /*              */
};                                                      /*              */
struct st_ssu {                                         /* struct SSU   */
              union {                                   /* SSCRH        */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char MSS :1;        /*    MSS       */
                           unsigned char BIDE:1;        /*    BIDE      */
                           unsigned char     :1;        /*              */
                           unsigned char SOL :1;        /*    SOL       */
                           unsigned char SOLP:1;        /*    SOLP      */
                           unsigned char SCKS:1;        /*    SCKS      */
                           unsigned char CSS :2;        /*    CSS       */
                           }      BIT;                  /*              */
                    }           SSCRH;                  /*              */
              union {                                   /* SSCRL        */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char      :1;       /*              */
                           unsigned char SSUMS:1;       /*    SSUMS     */
                           unsigned char SRES :1;       /*    SRES      */
                           unsigned char      :3;       /*              */
                           unsigned char DATS :2;       /*    DATS      */
                           }      BIT;                  /*              */
                    }           SSCRL;                  /*              */
              union {                                   /* SSMR         */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char MLS :1;        /*    MLS       */
                           unsigned char CPOS:1;        /*    CPOS      */
                           unsigned char CPHS:1;        /*    CPHS      */
                           unsigned char     :2;        /*              */
                           unsigned char CKS :3;        /*    CKS       */
                           }      BIT;                  /*              */
                    }           SSMR;                   /*              */
              union {                                   /* SSER         */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit Access  */
                           unsigned char TE  :1;        /*    TE        */
                           unsigned char RE  :1;        /*    RE        */
                           unsigned char     :2;        /*              */
                           unsigned char TEIE:1;        /*    TEIE      */
                           unsigned char TIE :1;        /*    TIE       */
                           unsigned char RIE :1;        /*    RIE       */
                           unsigned char CEIE:1;        /*    CEIE      */
                           }      BIT;                  /*              */
                    }           SSER;                   /*              */
              union {                                   /* SSSR         */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit Access  */
                           unsigned char     :1;        /*              */
                           unsigned char ORER:1;        /*    ORER      */
                           unsigned char     :2;        /*              */
                           unsigned char TEND:1;        /*    TEND      */
                           unsigned char TDRE:1;        /*    TDRE      */
                           unsigned char RDRF:1;        /*    RDRF      */
                           unsigned char CE  :1;        /*    CE        */
                           }      BIT;                  /*              */
                    }           SSSR;                   /*              */
              union {                                   /* SSCR2        */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit Access  */
                           unsigned char SDOS   :1;     /*    SDOS      */
                           unsigned char SSCKOS :1;     /*    SSCKOS    */
                           unsigned char SCSOS  :1;     /*    SCSOS     */
                           unsigned char TENDSTS:1;     /*    TENDSTS   */
                           unsigned char SCSATS :1;     /*    SCSATS    */
                           unsigned char SSODTS :1;     /*    SSODTS    */
                           }      BIT;                  /*              */
                    }           SSCR2;                  /*              */
              unsigned char     SSTDR0;                 /* SSTDR0       */
              unsigned char     SSTDR1;                 /* SSTDR1       */
              unsigned char     SSTDR2;                 /* SSTDR2       */
              unsigned char     SSTDR3;                 /* SSTDR3       */
              unsigned char     SSRDR0;                 /* SSRDR0       */
              unsigned char     SSRDR1;                 /* SSRDR1       */
              unsigned char     SSRDR2;                 /* SSRDR2       */
              unsigned char     SSRDR3;                 /* SSRDR3       */
};                                                      /*              */
struct st_p1 {                                          /* struct P1    */
             unsigned char      DDR;                    /* P1DDR        */
             char               wk1[15];                /*              */
             union {                                    /* P1ICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk2[943];               /*              */
             union {                                    /* P1PORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk3[15];                /*              */
             union {                                    /* P1DR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
};                                                      /*              */
struct st_p2 {                                          /* struct P2    */
             unsigned char      DDR;                    /* P2DDR        */
             char               wk1[15];                /*              */
             union {                                    /* P2ICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char   :4;           /*    Bit 7-4   */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk2[42];                /*              */
             union {                                    /* P2ODR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char   :4;           /*    Bit 7-4   */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ODR;                    /*              */
             char               wk3[900];               /*              */
             union {                                    /* P2PORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char   :4;           /*    Bit 7-4   */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk4[15];                /*              */
             union {                                    /* P2DR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char   :4;           /*    Bit 7-4   */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
};                                                      /*              */
struct st_p3 {                                          /* struct P3    */
             unsigned char      DDR;                    /* P3DDR        */
             char               wk1[15];                /*              */
             union {                                    /* P3ICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk2[943];               /*              */
             union {                                    /* P3PORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk3[15];                /*              */
             union {                                    /* P3DR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
};                                                      /*              */
struct st_p4 {                                          /* struct P4    */
             union {                                    /* P4ICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk1[943];               /*              */
             union {                                    /* P4PORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
};                                                      /*              */
struct st_p5 {                                          /* struct P5    */
             union {                                    /* P5ICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk1[943];               /*              */
             union {                                    /* P5PORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
};                                                      /*              */
struct st_p6 {                                          /* struct P6    */
             unsigned char      DDR;                    /* P6DDR        */
             char               wk1[15];                /*              */
             union {                                    /* P6ICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char   :1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk2[943];               /*              */
             union {                                    /* P6PORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char   :1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk3[15];                /*              */
             union {                                    /* P6DR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char   :1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
};                                                      /*              */
struct st_pa {                                          /* struct PA    */
             unsigned char      DDR;                    /* PADDR        */
             char               wk1[15];                /*              */
             union {                                    /* PAICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk2[943];               /*              */
             union {                                    /* PAPORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk3[15];                /*              */
             union {                                    /* PADR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
};                                                      /*              */
struct st_pd {                                          /* struct PD    */
             unsigned char      DDR;                    /* PDDDR        */
             char               wk1[15];                /*              */
             union {                                    /* PDICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk2[23];                /*              */
             union {                                    /* PDPCR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PCR;                    /*              */
             char               wk3[919];               /*              */
             union {                                    /* PDPORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk4[15];                /*              */
             union {                                    /* PDDR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
};                                                      /*              */
struct st_ph {                                          /* struct PH    */
             union {                                    /* PHRTIDR      */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            RTIDR;                  /*              */
             char               wk1[2399];              /*              */
             union {                                    /* PHPORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk2[3];                 /*              */
             union {                                    /* PHDR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
             char               wk3[3];                 /*              */
             unsigned char      DDR;                    /* PHDDR        */
             char               wk4[3];                 /*              */
             union {                                    /* PHICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk5[11];                /*              */
             union {                                    /* PHPCR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PCR;                    /*              */
};                                                      /*              */
struct st_pj {                                          /* struct PJ    */
             union {                                    /* PJPORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk1[3];                 /*              */
             union {                                    /* PJDR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
             char               wk2[3];                 /*              */
             unsigned char      DDR;                    /* PJDDR        */
             char               wk3[3];                 /*              */
             union {                                    /* PJICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk4[11];                /*              */
             union {                                    /* PJPCR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PCR;                    /*              */
};                                                      /*              */
struct st_pk {                                          /* struct PK    */
             union {                                    /* PKPORT       */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PORT;                   /*              */
             char               wk1[3];                 /*              */
             union {                                    /* PKDR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            DR;                     /*              */
             char               wk2[3];                 /*              */
             unsigned char      DDR;                    /* PKDDR        */
             char               wk3[3];                 /*              */
             union {                                    /* PKICR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            ICR;                    /*              */
             char               wk4[11];                /*              */
             union {                                    /* PKPCR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char B7:1;           /*    Bit 7     */
                          unsigned char B6:1;           /*    Bit 6     */
                          unsigned char B5:1;           /*    Bit 5     */
                          unsigned char B4:1;           /*    Bit 4     */
                          unsigned char B3:1;           /*    Bit 3     */
                          unsigned char B2:1;           /*    Bit 2     */
                          unsigned char B1:1;           /*    Bit 1     */
                          unsigned char B0:1;           /*    Bit 0     */
                          }      BIT;                   /*              */
                   }            PCR;                    /*              */
};                                                      /*              */
struct st_pfc {                                         /* struct PFC   */
              union {                                   /* PFCR9        */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char        :2;     /*              */
                           unsigned char TPUMS3A:1;     /*    TPUMS3A   */
                           unsigned char TPUMS3B:1;     /*    TPUMS3B   */
                           unsigned char TPUMS2 :1;     /*    TPUMS2    */
                           unsigned char TPUMS1 :1;     /*    TPUMS1    */
                           unsigned char TPUMS0A:1;     /*    TPUMS0A   */
                           unsigned char TPUMS0B:1;     /*    TPUMS0B   */
                           }      BIT;                  /*              */
                    }           PFCR9;                  /*              */
              union {                                   /* PFCRA        */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char TPUMS11:1;     /*    TPUMS11   */
                           unsigned char TPUMS10:1;     /*    TPUMS10   */
                           unsigned char TPUMS9A:1;     /*    TPUMS9A   */
                           unsigned char TPUMS9B:1;     /*    TPUMS9B   */
                           unsigned char TPUMS8 :1;     /*    TPUMS8    */
                           unsigned char TPUMS7 :1;     /*    TPUMS7    */
                           unsigned char TPUMS6A:1;     /*    TPUMS6A   */
                           unsigned char TPUMS6B:1;     /*    TPUMS6B   */
                           }      BIT;                  /*              */
                    }           PFCRA;                  /*              */
              union {                                   /* PFCRB        */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char      :1;       /*              */
                           unsigned char ITS14:1;       /*    ITS14     */
                           unsigned char ITS13:1;       /*    ITS13     */
                           unsigned char ITS12:1;       /*    ITS12     */
                           unsigned char ITS11:1;       /*    ITS11     */
                           unsigned char ITS10:1;       /*    ITS10     */
                           unsigned char ITS9 :1;       /*    ITS9      */
                           unsigned char ITS8 :1;       /*    ITS8      */
                           }      BIT;                  /*              */
                    }           PFCRB;                  /*              */
};                                                      /*              */
struct st_intc {                                        /* struct INTC  */
               union {                                  /* SSIER        */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :1;      /*              */
                            unsigned char SSI14:1;      /*    SSI14     */
                            unsigned char SSI13:1;      /*    SSI13     */
                            unsigned char SSI12:1;      /*    SSI12     */
                            unsigned char SSI11:1;      /*    SSI11     */
                            unsigned char SSI10:1;      /*    SSI10     */
                            unsigned char SSI9 :1;      /*    SSI9      */
                            unsigned char SSI8 :1;      /*    SSI8      */
                            unsigned char SSI7 :1;      /*    SSI7      */
                            unsigned char SSI6 :1;      /*    SSI6      */
                            unsigned char SSI5 :1;      /*    SSI5      */
                            unsigned char SSI4 :1;      /*    SSI4      */
                            unsigned char SSI3 :1;      /*    SSI3      */
                            unsigned char SSI2 :1;      /*    SSI2      */
                            unsigned char SSI1 :1;      /*    SSI1      */
                            unsigned char SSI0 :1;      /*    SSI0      */
                            }     BIT;                  /*              */
                     }          SSIER;                  /*              */
               char             wk1[368];               /*              */
               union {                                  /* IPRA         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :1;      /*              */
                            unsigned char _IRQ0:3;      /*    IRQ0      */
                            unsigned char      :1;      /*              */
                            unsigned char _IRQ1:3;      /*    IRQ1      */
                            unsigned char      :1;      /*              */
                            unsigned char _IRQ2:3;      /*    IRQ2      */
                            unsigned char      :1;      /*              */
                            unsigned char _IRQ3:3;      /*    IRQ3      */
                            }     BIT;                  /*              */
                     }          IPRA;                   /*              */
               union {                                  /* IPRB         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :1;      /*              */
                            unsigned char _IRQ4:3;      /*    IRQ4      */
                            unsigned char      :1;      /*              */
                            unsigned char _IRQ5:3;      /*    IRQ5      */
                            unsigned char      :1;      /*              */
                            unsigned char _IRQ6:3;      /*    IRQ6      */
                            unsigned char      :1;      /*              */
                            unsigned char _IRQ7:3;      /*    IRQ7      */
                            }     BIT;                  /*              */
                     }          IPRB;                   /*              */
               union {                                  /* IPRC         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char       :1;     /*              */
                            unsigned char _IRQ8 :3;     /*    IRQ8      */
                            unsigned char       :1;     /*              */
                            unsigned char _IRQ9 :3;     /*    IRQ9      */
                            unsigned char       :1;     /*              */
                            unsigned char _IRQ10:3;     /*    IRQ10     */
                            unsigned char       :1;     /*              */
                            unsigned char _IRQ11:3;     /*    IRQ11     */
                            }     BIT;                  /*              */
                     }          IPRC;                   /*              */
               union {                                  /* IPRD         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char       :1;     /*              */
                            unsigned char _IRQ12:3;     /*    IRQ12     */
                            unsigned char       :1;     /*              */
                            unsigned char _IRQ13:3;     /*    IRQ13     */
                            unsigned char       :1;     /*              */
                            unsigned char _IRQ14:3;     /*    IRQ14     */
                            }     BIT;                  /*              */
                     }          IPRD;                   /*              */
               union {                                  /* IPRE         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char     :5;       /*              */
                            unsigned char _WDT:3;       /*    WDT       */
                            }     BIT;                  /*              */
                     }          IPRE;                   /*              */
               union {                                  /* IPRF         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :5;      /*              */
                            unsigned char _AD  :3;      /*    A/D       */
                            unsigned char      :1;      /*              */
                            unsigned char _TPU0:3;      /*    TPU0      */
                            unsigned char      :1;      /*              */
                            unsigned char _TPU1:3;      /*    TPU1      */
                            }     BIT;                  /*              */
                     }          IPRF;                   /*              */
               union {                                  /* IPRG         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :1;      /*              */
                            unsigned char _TPU2:3;      /*    TPU2      */
                            unsigned char      :1;      /*              */
                            unsigned char _TPU3:3;      /*    TPU3      */
                            unsigned char      :1;      /*              */
                            unsigned char _TPU4:3;      /*    TPU4      */
                            unsigned char      :1;      /*              */
                            unsigned char _TPU5:3;      /*    TPU5      */
                            }     BIT;                  /*              */
                     }          IPRG;                   /*              */
               char             wk2[2];                 /*              */
               union {                                  /* IPRI         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char       :1;     /*              */
                            unsigned char _DMAC0:3;     /*    DMAC0     */
                            unsigned char       :1;     /*              */
                            unsigned char _DMAC1:3;     /*    DMAC1     */
                            unsigned char       :1;     /*              */
                            unsigned char _DMAC2:3;     /*    DMAC2     */
                            unsigned char       :1;     /*              */
                            unsigned char _DMAC3:3;     /*    DMAC3     */
                            }     BIT;                  /*              */
                     }          IPRI;                   /*              */
               char             wk3[2];                 /*              */
               union {                                  /* IPRK         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :1;      /*              */
                            unsigned char _DMAC:3;      /*    DMAC      */
                            }     BIT;                  /*              */
                     }          IPRK;                   /*              */
               union {                                  /* IPRL         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char       :5;     /*              */
                            unsigned char _SCI3 :3;     /*    SCI3      */
                            unsigned char       :1;     /*              */
                            unsigned char _SCI4 :3;     /*    SCI4      */
                            unsigned char       :1;     /*              */
                            unsigned char _TPU6G:3;     /*    TPU6(TGI) */
                            }     BIT;                  /*              */
                     }          IPRL;                   /*              */
               union {                                  /* IPRM         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char       :1;     /*              */
                            unsigned char _TPU6C:3;     /*    TPU6(TCI) */
                            unsigned char       :1;     /*              */
                            unsigned char _TPU7G:3;     /*    TPU7(TGI) */
                            unsigned char       :1;     /*              */
                            unsigned char _TPU7C:3;     /*    TPU7(TCI) */
                            unsigned char       :1;     /*              */
                            unsigned char _TPU8G:3;     /*    TPU8(TGI) */
                            }     BIT;                  /*              */
                     }          IPRM;                   /*              */
               union {                                  /* IPRN         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char        :1;    /*              */
                            unsigned char _TPU8C :3;    /*    TPU8(TCI) */
                            unsigned char        :1;    /*              */
                            unsigned char _TPU9G :3;    /*    TPU9(TGI) */
                            unsigned char        :1;    /*              */
                            unsigned char _TPU9C :3;    /*    TPU9(TCI) */
                            unsigned char        :1;    /*              */
                            unsigned char _TPU10G:3;    /*    TPU10(TGI)*/
                            }     BIT;                  /*              */
                     }          IPRN;                   /*              */
               union {                                  /* IPRO         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char        :1;    /*              */
                            unsigned char _TPU10C:3;    /*    TPU10(TCI)*/
                            unsigned char        :1;    /*              */
                            unsigned char _TPU11G:3;    /*    TPU11(TGI)*/
                            unsigned char        :1;    /*              */
                            unsigned char _TPU11C:3;    /*    TPU11(TCI)*/
                            }     BIT;                  /*              */
                     }          IPRO;                   /*              */
               char             wk4[2];                 /*              */
               union {                                  /* IPRQ         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :8;      /*              */
                            unsigned char      :5;      /*              */
                            unsigned char _HCAN:3;      /*    HCAN      */
                            }     BIT;                  /*              */
                     }          IPRQ;                   /*              */
               union {                                  /* IPRR         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char       :1;     /*              */
                            unsigned char _SSU0 :3;     /*    SSU0      */
                            unsigned char       :1;     /*              */
                            unsigned char _SSU01:3;     /*    SSU01     */
                            unsigned char       :1;     /*              */
                            unsigned char _SSU12:3;     /*    SSU12     */
                            unsigned char       :1;     /*              */
                            unsigned char _SSU2 :3;     /*    SSU2      */
                            }     BIT;                  /*              */
                     }          IPRR;                   /*              */
               char             wk5[4];                 /*              */
               union {                                  /* ISCR         */
                     unsigned long LONG;                /*  Long Access */
                     struct {                           /*  Word Access */
                            unsigned int H;             /*    ISCRH     */
                            unsigned int L;             /*    ISCRL     */
                            }      WORD;                /*              */
                     struct {                           /*  Bit  Access */
                            unsigned char        :2;    /*              */
                            unsigned char IRQ14SC:2;    /*    IRQ14SC   */
                            unsigned char IRQ13SC:2;    /*    IRQ13SC   */
                            unsigned char IRQ12SC:2;    /*    IRQ12SC   */
                            unsigned char IRQ11SC:2;    /*    IRQ11SC   */
                            unsigned char IRQ10SC:2;    /*    IRQ10SC   */
                            unsigned char IRQ9SC :2;    /*    IRQ9SC    */
                            unsigned char IRQ8SC :2;    /*    IRQ8SC    */
                            unsigned char IRQ7SC :2;    /*    IRQ7SC    */
                            unsigned char IRQ6SC :2;    /*    IRQ6SC    */
                            unsigned char IRQ5SC :2;    /*    IRQ5SC    */
                            unsigned char IRQ4SC :2;    /*    IRQ4SC    */
                            unsigned char IRQ3SC :2;    /*    IRQ3SC    */
                            unsigned char IRQ2SC :2;    /*    IRQ2SC    */
                            unsigned char IRQ1SC :2;    /*    IRQ1SC    */
                            unsigned char IRQ0SC :2;    /*    IRQ0SC    */
                            }      BIT;                 /*              */
                     }          ISCR;                   /*              */
               char             wk6[454];               /*              */
               union {                                  /* INTCR        */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :2;      /*              */
                            unsigned char INTM :2;      /*    INTM      */
                            unsigned char NMIEG:1;      /*    NMIEG     */
                            }      BIT;                 /*              */
                     }          INTCR;                  /*              */
               union {                                  /* CPUPCR       */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char CPUPCE:1;     /*    CPUPCE    */
                            unsigned char       :3;     /*              */
                            unsigned char IPSETE:1;     /*    IPSETE    */
                            unsigned char CPUP  :3;     /*    CPUP      */
                            }      BIT;                 /*              */
                     }          CPUPCR;                 /*              */
               union {                                  /* IER          */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char       :1;     /*              */
                            unsigned char IRQ14E:1;     /*    IRQ14E    */
                            unsigned char IRQ13E:1;     /*    IRQ13E    */
                            unsigned char IRQ12E:1;     /*    IRQ12E    */
                            unsigned char IRQ11E:1;     /*    IRQ11E    */
                            unsigned char IRQ10E:1;     /*    IRQ10E    */
                            unsigned char IRQ9E :1;     /*    IRQ9E     */
                            unsigned char IRQ8E :1;     /*    IRQ8E     */
                            unsigned char IRQ7E :1;     /*    IRQ7E     */
                            unsigned char IRQ6E :1;     /*    IRQ6E     */
                            unsigned char IRQ5E :1;     /*    IRQ5E     */
                            unsigned char IRQ4E :1;     /*    IRQ4E     */
                            unsigned char IRQ3E :1;     /*    IRQ3E     */
                            unsigned char IRQ2E :1;     /*    IRQ2E     */
                            unsigned char IRQ1E :1;     /*    IRQ1E     */
                            unsigned char IRQ0E :1;     /*    IRQ0E     */
                            }     BIT;                  /*              */
                     }          IER;                    /*              */
               union {                                  /* ISR          */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char       :1;     /*              */
                            unsigned char IRQ14F:1;     /*    IRQ14F    */
                            unsigned char IRQ13F:1;     /*    IRQ13F    */
                            unsigned char IRQ12F:1;     /*    IRQ12F    */
                            unsigned char IRQ11F:1;     /*    IRQ11F    */
                            unsigned char IRQ10F:1;     /*    IRQ10F    */
                            unsigned char IRQ9F :1;     /*    IRQ9F     */
                            unsigned char IRQ8F :1;     /*    IRQ8F     */
                            unsigned char IRQ7F :1;     /*    IRQ7F     */
                            unsigned char IRQ6F :1;     /*    IRQ6F     */
                            unsigned char IRQ5F :1;     /*    IRQ5F     */
                            unsigned char IRQ4F :1;     /*    IRQ4F     */
                            unsigned char IRQ3F :1;     /*    IRQ3F     */
                            unsigned char IRQ2F :1;     /*    IRQ2F     */
                            unsigned char IRQ1F :1;     /*    IRQ1F     */
                            unsigned char IRQ0F :1;     /*    IRQ0F     */
                            }     BIT;                  /*              */
                     }          ISR;                    /*              */
};                                                      /*              */
struct st_dmac0 {                                       /* struct DMAC0 */
                void           *DSAR;                   /* DSAR         */
                void           *DDAR;                   /* DDAR         */
                unsigned long   DOFR;                   /* DOFR         */
                unsigned long   DTCR;                   /* DTCR         */
                unsigned long   DBSR;                   /* DBSR         */
                union {                                 /* DMDR         */
                      unsigned long LONG;               /*  Long Access */
                      struct {                          /*  Bit  Access */
                             unsigned char DTE  :1;     /*    DTE       */
                             unsigned char DACKE:1;     /*    DACKE     */
                             unsigned char TENDE:1;     /*    TENDE     */
                             unsigned char      :1;     /*              */
                             unsigned char DREQS:1;     /*    DREQS     */
                             unsigned char NRD  :1;     /*    NRD       */
                             unsigned char      :2;     /*              */
                             unsigned char ACT  :1;     /*    ACT       */
                             unsigned char      :3;     /*              */
                             unsigned char ERRF :1;     /*    ERRF      */
                             unsigned char      :1;     /*              */
                             unsigned char ESIF :1;     /*    ESIF      */
                             unsigned char DTIF :1;     /*    DTIF      */
                             unsigned char DTSZ :2;     /*    DTSZ      */
                             unsigned char MDS  :2;     /*    MDS       */
                             unsigned char TSEIE:1;     /*    TSEIE     */
                             unsigned char      :1;     /*              */
                             unsigned char ESIE :1;     /*    ESIE      */
                             unsigned char DTIE :1;     /*    DTIE      */
                             unsigned char DTF  :2;     /*    DTF       */
                             unsigned char DTA  :1;     /*    DTA       */
                             unsigned char      :2;     /*              */
                             unsigned char DMAP :3;     /*    DMAP      */
                             }      BIT;                /*              */
                      }         DMDR;                   /*              */
                union {                                 /* DACR         */
                      unsigned long LONG;               /*  Long Access */
                      struct {                          /*  Bit  Access */
                             unsigned char AMS  :1;     /*    AMS       */
                             unsigned char DIRS :1;     /*    DIRS      */
                             unsigned char      :3;     /*              */
                             unsigned char RPTIE:1;     /*    RPTIE     */
                             unsigned char ARS  :2;     /*    ARS       */
                             unsigned char      :2;     /*              */
                             unsigned char SAT  :2;     /*    SAT       */
                             unsigned char      :2;     /*              */
                             unsigned char DAT  :2;     /*    DAT       */
                             unsigned char SARIE:1;     /*    SARIE     */
                             unsigned char      :2;     /*              */
                             unsigned char SARA :5;     /*    SARA      */
                             unsigned char DARIE:1;     /*    DARIE     */
                             unsigned char      :2;     /*              */
                             unsigned char DARA :5;     /*    DARA      */
                             }      BIT;                /*              */
                      }         DACR;                   /*              */
                char            wk[260];                /*              */
                unsigned char   DMRSR;                  /* DMRSR        */
};                                                      /*              */
struct st_dmac1 {                                       /* struct DMAC1 */
                void           *DSAR;                   /* DSAR         */
                void           *DDAR;                   /* DDAR         */
                unsigned long   DOFR;                   /* DOFR         */
                unsigned long   DTCR;                   /* DTCR         */
                unsigned long   DBSR;                   /* DBSR         */
                union {                                 /* DMDR         */
                      unsigned long LONG;               /*  Long Access */
                      struct {                          /*  Bit  Access */
                             unsigned char DTE  :1;     /*    DTE       */
                             unsigned char DACKE:1;     /*    DACKE     */
                             unsigned char TENDE:1;     /*    TENDE     */
                             unsigned char      :1;     /*              */
                             unsigned char DREQS:1;     /*    DREQS     */
                             unsigned char NRD  :1;     /*    NRD       */
                             unsigned char      :2;     /*              */
                             unsigned char ACT  :1;     /*    ACT       */
                             unsigned char      :5;     /*              */
                             unsigned char ESIF :1;     /*    ESIF      */
                             unsigned char DTIF :1;     /*    DTIF      */
                             unsigned char DTSZ :2;     /*    DTSZ      */
                             unsigned char MDS  :2;     /*    MDS       */
                             unsigned char TSEIE:1;     /*    TSEIE     */
                             unsigned char      :1;     /*              */
                             unsigned char ESIE :1;     /*    ESIE      */
                             unsigned char DTIE :1;     /*    DTIE      */
                             unsigned char DTF  :2;     /*    DTF       */
                             unsigned char DTA  :1;     /*    DTA       */
                             unsigned char      :2;     /*              */
                             unsigned char DMAP :3;     /*    DMAP      */
                             }      BIT;                /*              */
                      }         DMDR;                   /*              */
                union {                                 /* DACR         */
                      unsigned long LONG;               /*  Long Access */
                      struct {                          /*  Bit  Access */
                             unsigned char AMS  :1;     /*    AMS       */
                             unsigned char DIRS :1;     /*    DIRS      */
                             unsigned char      :3;     /*              */
                             unsigned char RPTIE:1;     /*    RPTIE     */
                             unsigned char ARS  :2;     /*    ARS       */
                             unsigned char      :2;     /*              */
                             unsigned char SAT  :2;     /*    SAT       */
                             unsigned char      :2;     /*              */
                             unsigned char DAT  :2;     /*    DAT       */
                             unsigned char SARIE:1;     /*    SARIE     */
                             unsigned char      :2;     /*              */
                             unsigned char SARA :5;     /*    SARA      */
                             unsigned char DARIE:1;     /*    DARIE     */
                             unsigned char      :2;     /*              */
                             unsigned char DARA :5;     /*    DARA      */
                             }      BIT;                /*              */
                      }         DACR;                   /*              */
                char            wk[229];                /*              */
                unsigned char   DMRSR;                  /* DMRSR        */
};                                                      /*              */
struct st_dmac2 {                                       /* struct DMAC2 */
                void           *DSAR;                   /* DSAR         */
                void           *DDAR;                   /* DDAR         */
                unsigned long   DOFR;                   /* DOFR         */
                unsigned long   DTCR;                   /* DTCR         */
                unsigned long   DBSR;                   /* DBSR         */
                union {                                 /* DMDR         */
                      unsigned long LONG;               /*  Long Access */
                      struct {                          /*  Bit  Access */
                             unsigned char DTE  :1;     /*    DTE       */
                             unsigned char DACKE:1;     /*    DACKE     */
                             unsigned char TENDE:1;     /*    TENDE     */
                             unsigned char      :1;     /*              */
                             unsigned char DREQS:1;     /*    DREQS     */
                             unsigned char NRD  :1;     /*    NRD       */
                             unsigned char      :2;     /*              */
                             unsigned char ACT  :1;     /*    ACT       */
                             unsigned char      :5;     /*              */
                             unsigned char ESIF :1;     /*    ESIF      */
                             unsigned char DTIF :1;     /*    DTIF      */
                             unsigned char DTSZ :2;     /*    DTSZ      */
                             unsigned char MDS  :2;     /*    MDS       */
                             unsigned char TSEIE:1;     /*    TSEIE     */
                             unsigned char      :1;     /*              */
                             unsigned char ESIE :1;     /*    ESIE      */
                             unsigned char DTIE :1;     /*    DTIE      */
                             unsigned char DTF  :2;     /*    DTF       */
                             unsigned char DTA  :1;     /*    DTA       */
                             unsigned char      :2;     /*              */
                             unsigned char DMAP :3;     /*    DMAP      */
                             }      BIT;                /*              */
                      }         DMDR;                   /*              */
                union {                                 /* DACR         */
                      unsigned long LONG;               /*  Long Access */
                      struct {                          /*  Bit  Access */
                             unsigned char AMS  :1;     /*    AMS       */
                             unsigned char DIRS :1;     /*    DIRS      */
                             unsigned char      :3;     /*              */
                             unsigned char RPTIE:1;     /*    RPTIE     */
                             unsigned char ARS  :2;     /*    ARS       */
                             unsigned char      :2;     /*              */
                             unsigned char SAT  :2;     /*    SAT       */
                             unsigned char      :2;     /*              */
                             unsigned char DAT  :2;     /*    DAT       */
                             unsigned char SARIE:1;     /*    SARIE     */
                             unsigned char      :2;     /*              */
                             unsigned char SARA :5;     /*    SARA      */
                             unsigned char DARIE:1;     /*    DARIE     */
                             unsigned char      :2;     /*              */
                             unsigned char DARA :5;     /*    DARA      */
                             }      BIT;                /*              */
                      }         DACR;                   /*              */
                char            wk[198];                /*              */
                unsigned char   DMRSR;                  /* DMRSR        */
};                                                      /*              */
struct st_dmac3 {                                       /* struct DMAC3 */
                void           *DSAR;                   /* DSAR         */
                void           *DDAR;                   /* DDAR         */
                unsigned long   DOFR;                   /* DOFR         */
                unsigned long   DTCR;                   /* DTCR         */
                unsigned long   DBSR;                   /* DBSR         */
                union {                                 /* DMDR         */
                      unsigned long LONG;               /*  Long Access */
                      struct {                          /*  Bit  Access */
                             unsigned char DTE  :1;     /*    DTE       */
                             unsigned char DACKE:1;     /*    DACKE     */
                             unsigned char TENDE:1;     /*    TENDE     */
                             unsigned char      :1;     /*              */
                             unsigned char DREQS:1;     /*    DREQS     */
                             unsigned char NRD  :1;     /*    NRD       */
                             unsigned char      :2;     /*              */
                             unsigned char ACT  :1;     /*    ACT       */
                             unsigned char      :5;     /*              */
                             unsigned char ESIF :1;     /*    ESIF      */
                             unsigned char DTIF :1;     /*    DTIF      */
                             unsigned char DTSZ :2;     /*    DTSZ      */
                             unsigned char MDS  :2;     /*    MDS       */
                             unsigned char TSEIE:1;     /*    TSEIE     */
                             unsigned char      :1;     /*              */
                             unsigned char ESIE :1;     /*    ESIE      */
                             unsigned char DTIE :1;     /*    DTIE      */
                             unsigned char DTF  :2;     /*    DTF       */
                             unsigned char DTA  :1;     /*    DTA       */
                             unsigned char      :2;     /*              */
                             unsigned char DMAP :3;     /*    DMAP      */
                             }      BIT;                /*              */
                      }         DMDR;                   /*              */
                union {                                 /* DACR         */
                      unsigned long LONG;               /*  Long Access */
                      struct {                          /*  Bit  Access */
                             unsigned char AMS  :1;     /*    AMS       */
                             unsigned char DIRS :1;     /*    DIRS      */
                             unsigned char      :3;     /*              */
                             unsigned char RPTIE:1;     /*    RPTIE     */
                             unsigned char ARS  :2;     /*    ARS       */
                             unsigned char      :2;     /*              */
                             unsigned char SAT  :2;     /*    SAT       */
                             unsigned char      :2;     /*              */
                             unsigned char DAT  :2;     /*    DAT       */
                             unsigned char SARIE:1;     /*    SARIE     */
                             unsigned char      :2;     /*              */
                             unsigned char SARA :5;     /*    SARA      */
                             unsigned char DARIE:1;     /*    DARIE     */
                             unsigned char      :2;     /*              */
                             unsigned char DARA :5;     /*    DARA      */
                             }      BIT;                /*              */
                      }         DACR;                   /*              */
                char            wk[167];                /*              */
                unsigned char   DMRSR;                  /* DMRSR        */
};                                                      /*              */
struct st_bsc {                                         /* struct BSC   */
              union {                                   /* BCR2         */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char      :3;       /*              */
                           unsigned char IBCCS:1;       /*    IBCCS     */
                           unsigned char      :3;       /*              */
                           unsigned char PWDBE:1;       /*    PWDBE     */
                           }      BIT;                  /*              */
                    }           BCR2;                   /*              */
};                                                      /*              */
union un_mdcr {                                         /* union MDCR   */
              unsigned int WORD;                        /*  Word Access */
              struct {                                  /*  Bit  Access */
                     unsigned char    :4;               /*              */
                     unsigned char MDS:4;               /*    MDS       */
                     }      BIT;                        /*              */
};                                                      /*              */
union un_syscr {                                        /* union SYSCR  */
               unsigned int WORD;                       /*  Word Access */
               struct {                                 /*  Bit  Access */
                      unsigned char        :2;          /*              */
                      unsigned char MACS   :1;          /*    MACS      */
                      unsigned char        :1;          /*              */
                      unsigned char FETCHMD:1;          /*    FETCHMD   */
                      unsigned char        :2;          /*              */
                      unsigned char RAME   :1;          /*    RAME      */
                      unsigned char FLSHE  :1;          /*    FLSHE     */
                      }      BIT;                       /*              */
};                                                      /*              */
union un_sckcr {                                        /* union SCKCR  */
               unsigned int WORD;                       /*  Word Access */
               struct {                                 /*  Bit  Access */
                      unsigned char PSTOP1:1;           /*    PSTOP1    */
                      unsigned char       :1;           /*              */
                      unsigned char POSEL1:1;           /*    POSEL1    */
                      unsigned char       :2;           /*              */
                      unsigned char ICK   :3;           /*    ICK       */
                      unsigned char       :1;           /*              */
                      unsigned char PCK   :3;           /*    PCK       */
                      unsigned char       :1;           /*              */
                      unsigned char BCK   :3;           /*    BCK       */
                      }      BIT;                       /*              */
};                                                      /*              */
union un_sbycr {                                        /* union SBYCR  */
               unsigned char BYTE;                      /*  Byte Access */
               struct {                                 /*  Bit  Access */
                      unsigned char SSBY:1;             /*    SSBY      */
                      unsigned char     :2;             /*              */
                      unsigned char STS :5;             /*    STS       */
                      }      BIT;                       /*              */
};                                                      /*              */
struct st_mstp {                                        /* struct MSTP  */
               union {                                  /* CRA          */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char ACSE    :1;   /*    ACSE      */
                            unsigned char         :1;   /*              */
                            unsigned char _DMAC   :1;   /*    DMAC      */
                            unsigned char         :5;   /*              */
                            unsigned char         :3;   /*              */
                            unsigned char _AD1    :1;   /*    A/D1      */
                            unsigned char _AD0    :1;   /*    A/D0      */
                            unsigned char         :1;   /*              */
                            unsigned char _TPU11_6:1;   /*    TPU11-6   */
                            unsigned char _TPU5_0 :1;   /*    TPU5-0    */
                            }     BIT;                  /*              */
                     }          CRA;                    /*              */
               union {                                  /* CRB          */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char _PPG :1;      /*    PPG       */
                            unsigned char      :2;      /*              */
                            unsigned char _SCI4:1;      /*    SCI4      */
                            unsigned char _SCI3:1;      /*    SCI3      */
                            }     BIT;                  /*              */
                     }          CRB;                    /*              */
               union {                                  /* CRC          */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Bit  Access */
                            unsigned char      :4;      /*              */
                            unsigned char _HCAN:1;      /*    HCAN      */
                            unsigned char _SSU2:1;      /*    SSU2      */
                            unsigned char _SSU1:1;      /*    SSU1      */
                            unsigned char _SSU0:1;      /*    SSU0      */
                            unsigned char      :6;      /*              */
                            unsigned char _RAM1:1;      /*    RAM1      */
                            unsigned char _RAM0:1;      /*    RAM0      */
                            }     BIT;                  /*              */
                     }          CRC;                    /*              */
};                                                      /*              */
struct st_flash {                                       /* struct FLASH */
                union {                                 /* RAMCR        */
                      unsigned char BYTE;               /*  Byte Access */
                      struct {                          /*  Bit  Access */
                             unsigned char     :4;      /*              */
                             unsigned char RAMS:1;      /*    RAMS      */
                             unsigned char RAM :3;      /*    RAM       */
                             }      BIT;                /*              */
                      }         RAMER;                  /*              */
                char            wk1[265];               /*              */
                union {                                 /* FCCS         */
                      unsigned char BYTE;               /*  Byte Access */
                      struct {                          /*  Bit  Access */
                             unsigned char     :3;      /*              */
                             unsigned char FLER:1;      /*    FLER      */
                             unsigned char     :3;      /*              */
                             unsigned char SCO :1;      /*    SCO       */
                             }      BIT;                /*              */
                      }         FCCS;                   /*              */
                union {                                 /* FPCS         */
                      unsigned char BYTE;               /*  Byte Access */
                      struct {                          /*  Bit  Access */
                             unsigned char     :7;      /*              */
                             unsigned char PPVS:1;      /*    PPVS      */
                             }      BIT;                /*              */
                      }         FPCS;                   /*              */
                union {                                 /* FECS         */
                      unsigned char BYTE;               /*  Byte Access */
                      struct {                          /*  Bit  Access */
                             unsigned char     :7;      /*              */
                             unsigned char EPVB:1;      /*    EPVB      */
                             }      BIT;                /*              */
                      }         FECS;                   /*              */
                char            wk2;                    /*              */
                unsigned char   FKEY;                   /* FKEY         */
                unsigned char   FMATS;                  /* FMATS        */
                union {                                 /* FTDAR        */
                      unsigned char BYTE;               /*  Byte Access */
                      struct {                          /*  Bit  Access */
                             unsigned char TDER:1;      /*    TDER      */
                             unsigned char TDA :7;      /*    TDA       */
                             }      BIT;                /*              */
                      }         FTDAR;                  /*              */
};                                                      /*              */
struct st_ppg {                                         /* struct PPG   */
              union {                                   /* PCR          */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char G3CMS:2;       /*    G3CMS     */
                           unsigned char G2CMS:2;       /*    G2CMS     */
                           }      BIT;                  /*              */
                    }           PCR;                    /*              */
              union {                                   /* PMR          */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char G3INV:1;       /*    G3INV     */
                           unsigned char G2INV:1;       /*    G2INV     */
                           unsigned char      :2;       /*              */
                           unsigned char G3NOV:1;       /*    G3NOV     */
                           unsigned char G2NOV:1;       /*    G2NOV     */
                           }      BIT;                  /*              */
                    }           PMR;                    /*              */
              union {                                   /* NDER         */
                    unsigned int WORD;                  /*  Word Access */
                    struct {                            /*  Bit  Access */
                           unsigned char H;             /*    NDERH     */
                           unsigned char L;             /*    NDERL     */
                           }     BYTE;                  /*              */
                    struct {                            /*  Bit  Access */
                           unsigned char B15:1;         /*    NDER15    */
                           unsigned char B14:1;         /*    NDER14    */
                           unsigned char B13:1;         /*    NDER13    */
                           unsigned char B12:1;         /*    NDER12    */
                           unsigned char B11:1;         /*    NDER11    */
                           unsigned char B10:1;         /*    NDER10    */
                           unsigned char B9 :1;         /*    NDER9     */
                           unsigned char B8 :1;         /*    NDER8     */
                           unsigned char B7 :1;         /*    NDER7     */
                           unsigned char B6 :1;         /*    NDER6     */
                           unsigned char B5 :1;         /*    NDER5     */
                           unsigned char B4 :1;         /*    NDER4     */
                           unsigned char B3 :1;         /*    NDER3     */
                           unsigned char B2 :1;         /*    NDER2     */
                           unsigned char B1 :1;         /*    NDER1     */
                           unsigned char B0 :1;         /*    NDER0     */
                           }      BIT;                  /*              */
                    }           NDER;                   /*              */
              union {                                   /* PODR         */
                    unsigned int WORD;                  /*  Word Access */
                    struct {                            /*  Bit  Access */
                           unsigned char H;             /*    PODRH     */
                           unsigned char L;             /*    PODRL     */
                           }     BYTE;                  /*              */
                    struct {                            /*  Bit  Access */
                           unsigned char B15:1;         /*    NDER15    */
                           unsigned char B14:1;         /*    NDER14    */
                           unsigned char B13:1;         /*    NDER13    */
                           unsigned char B12:1;         /*    NDER12    */
                           unsigned char B11:1;         /*    NDER11    */
                           unsigned char B10:1;         /*    NDER10    */
                           unsigned char B9 :1;         /*    NDER9     */
                           unsigned char B8 :1;         /*    NDER8     */
                           unsigned char B7 :1;         /*    NDER7     */
                           unsigned char B6 :1;         /*    NDER6     */
                           unsigned char B5 :1;         /*    NDER5     */
                           unsigned char B4 :1;         /*    NDER4     */
                           unsigned char B3 :1;         /*    NDER3     */
                           unsigned char B2 :1;         /*    NDER2     */
                           unsigned char B1 :1;         /*    NDER1     */
                           unsigned char B0 :1;         /*    NDER0     */
                           }     BIT;                   /*              */
                    }           PODR;                   /*              */
              union {                                   /* NDRH (H'7C)  */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char B15:1;         /*    NDR15     */
                           unsigned char B14:1;         /*    NDR14     */
                           unsigned char B13:1;         /*    NDR13     */
                           unsigned char B12:1;         /*    NDR12     */
                           unsigned char B11:1;         /*    NDR11     */
                           unsigned char B10:1;         /*    NDR10     */
                           unsigned char B9 :1;         /*    NDR9      */
                           unsigned char B8 :1;         /*    NDR8      */
                           }      BIT;                  /*              */
                    }           NDRH1;                  /*              */
              union {                                   /* NDRL (H'7D)  */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char B7:1;          /*    NDR7      */
                           unsigned char B6:1;          /*    NDR6      */
                           unsigned char B5:1;          /*    NDR5      */
                           unsigned char B4:1;          /*    NDR4      */
                           unsigned char B3:1;          /*    NDR3      */
                           unsigned char B2:1;          /*    NDR2      */
                           unsigned char B1:1;          /*    NDR1      */
                           unsigned char B0:1;          /*    NDR0      */
                           }      BIT;                  /*              */
                    }           NDRL1;                  /*              */
              union {                                   /* NDRH (H'7E)  */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char    :4;         /*              */
                           unsigned char B11:1;         /*    NDR11     */
                           unsigned char B10:1;         /*    NDR10     */
                           unsigned char B9 :1;         /*    NDR9      */
                           unsigned char B8 :1;         /*    NDR8      */
                           }      BIT;                  /*              */
                    }           NDRH2;                  /*              */
              union {                                   /* NDRL (H'7F)  */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char   :4;          /*              */
                           unsigned char B3:1;          /*    NDR3      */
                           unsigned char B2:1;          /*    NDR2      */
                           unsigned char B1:1;          /*    NDR1      */
                           unsigned char B0:1;          /*    NDR0      */
                           }      BIT;                  /*              */
                    }           NDRL2;                  /*              */
};                                                      /*              */
struct st_sci {                                         /* struct SCI   */
              union {                                   /* SMR          */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char CA  :1;        /*    C/A       */
                           unsigned char CHR :1;        /*    CHR       */
                           unsigned char PE  :1;        /*    PE        */
                           unsigned char OE  :1;        /*    O/E       */
                           unsigned char STOP:1;        /*    STOP      */
                           unsigned char MP  :1;        /*    MP        */
                           unsigned char CKS :2;        /*    CKS       */
                           }      BIT;                  /*              */
                    }           SMR;                    /*              */
              unsigned char     BRR;                    /* BRR          */
              union {                                   /* SCR          */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char TIE :1;        /*    TIE       */
                           unsigned char RIE :1;        /*    RIE       */
                           unsigned char TE  :1;        /*    TE        */
                           unsigned char RE  :1;        /*    RE        */
                           unsigned char MPIE:1;        /*    MPIE      */
                           unsigned char TEIE:1;        /*    TEIE      */
                           unsigned char CKE :2;        /*    CKE       */
                           }      BIT;                  /*              */
                    }           SCR;                    /*              */
              unsigned char     TDR;                    /* TDR          */
              union {                                   /* SSR          */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char TDRE:1;        /*    TDRE      */
                           unsigned char RDRF:1;        /*    RDRF      */
                           unsigned char ORER:1;        /*    ORER      */
                           unsigned char FER :1;        /*    FER       */
                           unsigned char PER :1;        /*    PER       */
                           unsigned char TEND:1;        /*    TEND      */
                           unsigned char MPB :1;        /*    MPB       */
                           unsigned char MPBT:1;        /*    MPBT      */
                           }      BIT;                  /*              */
                    }           SSR;                    /*              */
              unsigned char     RDR;                    /* RDR          */
              union {                                   /* SCMR         */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char     :4;        /*              */
                           unsigned char SDIR:1;        /*    SDIR      */
                           unsigned char SINV:1;        /*    SINV      */
                           unsigned char     :1;        /*              */
                           unsigned char SMIF:1;        /*    SMIF      */
                           }      BIT;                  /*              */
                    }           SCMR;                   /*              */
};                                                      /*              */
struct st_smci {                                        /* struct SMCI  */
               union {                                  /* SMR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char GM :1;        /*    GM        */
                            unsigned char BLK:1;        /*    BLK       */
                            unsigned char PE :1;        /*    PE        */
                            unsigned char OE :1;        /*    O/E       */
                            unsigned char BCP:2;        /*    BCP       */
                            unsigned char CKS:2;        /*    CKS       */
                            }      BIT;                 /*              */
                     }          SMR;                    /*              */
               unsigned char    BRR;                    /* BRR          */
               union {                                  /* SCR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char TIE :1;       /*    TIE       */
                            unsigned char RIE :1;       /*    RIE       */
                            unsigned char TE  :1;       /*    TE        */
                            unsigned char RE  :1;       /*    RE        */
                            unsigned char MPIE:1;       /*    MPIE      */
                            unsigned char TEIE:1;       /*    TEIE      */
                            unsigned char CKE :2;       /*    CKE       */
                            }      BIT;                 /*              */
                     }          SCR;                    /*              */
               unsigned char    TDR;                    /* TDR          */
               union {                                  /* SSR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char TDRE:1;       /*    TDRE      */
                            unsigned char RDRF:1;       /*    RDRF      */
                            unsigned char ORER:1;       /*    ORER      */
                            unsigned char ERS :1;       /*    ERS       */
                            unsigned char PER :1;       /*    PER       */
                            unsigned char TEND:1;       /*    TEND      */
                            unsigned char MPB :1;       /*    MPB       */
                            unsigned char MPBT:1;       /*    MPBT      */
                            }      BIT;                 /*              */
                     }          SSR;                    /*              */
               unsigned char    RDR;                    /* RDR          */
               union {                                  /* SCMR         */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char     :4;       /*              */
                            unsigned char SDIR:1;       /*    SDIR      */
                            unsigned char SINV:1;       /*    SINV      */
                            unsigned char     :1;       /*              */
                            unsigned char SMIF:1;       /*    SMIF      */
                            }      BIT;                 /*              */
                     }          SCMR;                   /*              */
};                                                      /*              */
struct st_ad {                                          /* struct A/D   */
             unsigned int       ADDRA;                  /* ADDRA        */
             unsigned int       ADDRB;                  /* ADDRB        */
             unsigned int       ADDRC;                  /* ADDRC        */
             unsigned int       ADDRD;                  /* ADDRD        */
             unsigned int       ADDRE;                  /* ADDRE        */
             unsigned int       ADDRF;                  /* ADDRF        */
             unsigned int       ADDRG;                  /* ADDRG        */
             unsigned int       ADDRH;                  /* ADDRH        */
             union {                                    /* ADCSR        */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char ADF :1;         /*    ADF       */
                          unsigned char ADIE:1;         /*    ADIE      */
                          unsigned char ADST:1;         /*    ADST      */
                          unsigned char     :1;         /*              */
                          unsigned char CH  :4;         /*    CH        */
                          }      BIT;                   /*              */
                   }            ADCSR;                  /*              */
             union {                                    /* ADCR         */
                   unsigned char BYTE;                  /*  Byte Access */
                   struct {                             /*  Bit  Access */
                          unsigned char TRGS :2;        /*    TRGS      */
                          unsigned char SCANE:1;        /*    SCANE     */
                          unsigned char SCANS:1;        /*    SCANS     */
                          unsigned char CKS  :2;        /*    CKS       */
                          }      BIT;                   /*              */
                   }            ADCR;                   /*              */
};                                                      /*              */
union un_wdt {                                          /* union WDT    */
             struct {                                   /* Read  Access */
                    union {                             /* TCSR         */
                          unsigned char BYTE;           /*  Byte Access */
                          struct {                      /*  Bit  Access */
                                 unsigned char OVF :1;  /*    OVF       */
                                 unsigned char WTIT:1;  /*    WT/IT     */
                                 unsigned char TME :1;  /*    TME       */
                                 unsigned char     :2;  /*              */
                                 unsigned char CKS :3;  /*    CKS       */
                                 }      BIT;            /*              */
                          }       TCSR;                 /*              */
                    unsigned char TCNT;                 /* TCNT         */
                    char          wk;                   /*              */
                    union {                             /* RSTCSR       */
                          unsigned char BYTE;           /*  Byte Access */
                          struct {                      /*              */
                                 unsigned char WOVF:1;  /*    WOVF      */
                                 unsigned char RSTE:1;  /*    RSTE      */
                                 }      BIT;            /*              */
                          }       RSTCSR;               /*              */
                    } READ;                             /*              */
             struct {                                   /* Write Access */
                    unsigned int  TCSR;                 /* TCSR/TCNT    */
                    unsigned int  RSTCSR;               /* RSTCSR       */
                    } WRITE;                            /*              */
};                                                      /*              */
struct st_tpu {                                         /* struct TPU   */
              union {                                   /* TSTRB        */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char      :2;       /*              */
                           unsigned char CST11:1;       /*    CST11     */
                           unsigned char CST10:1;       /*    CST10     */
                           unsigned char CST9 :1;       /*    CST9      */
                           unsigned char CST8 :1;       /*    CST8      */
                           unsigned char CST7 :1;       /*    CST7      */
                           unsigned char CST6 :1;       /*    CST6      */
                           }      BIT;                  /*              */
                    }           TSTRB;                  /*              */
              union {                                   /* TSYRB        */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char       :2;      /*              */
                           unsigned char SYNC11:1;      /*    SYNC11    */
                           unsigned char SYNC10:1;      /*    SYNC10    */
                           unsigned char SYNC9 :1;      /*    SYNC9     */
                           unsigned char SYNC8 :1;      /*    SYNC8     */
                           unsigned char SYNC7 :1;      /*    SYNC7     */
                           unsigned char SYNC6 :1;      /*    SYNC6     */
                           }      BIT;                  /*              */
                    }           TSYRB;                  /*              */
              char              wk[1210];               /*              */
              union {                                   /* TSTR         */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char     :2;        /*              */
                           unsigned char CST5:1;        /*    CST5      */
                           unsigned char CST4:1;        /*    CST4      */
                           unsigned char CST3:1;        /*    CST3      */
                           unsigned char CST2:1;        /*    CST2      */
                           unsigned char CST1:1;        /*    CST1      */
                           unsigned char CST0:1;        /*    CST0      */
                           }      BIT;                  /*              */
                    }           TSTR;                   /*              */
              union {                                   /* TSYR         */
                    unsigned char BYTE;                 /*  Byte Access */
                    struct {                            /*  Bit  Access */
                           unsigned char      :2;       /*              */
                           unsigned char SYNC5:1;       /*    SYNC5     */
                           unsigned char SYNC4:1;       /*    SYNC4     */
                           unsigned char SYNC3:1;       /*    SYNC3     */
                           unsigned char SYNC2:1;       /*    SYNC2     */
                           unsigned char SYNC1:1;       /*    SYNC1     */
                           unsigned char SYNC0:1;       /*    SYNC0     */
                           }      BIT;                  /*              */
                    }           TSYR;                   /*              */
};                                                      /*              */
struct st_tpu0 {                                        /* struct TPU0  */
               union {                                  /* TCR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char CCLR:3;       /*    CCLR      */
                            unsigned char CKEG:2;       /*    CKEG      */
                            unsigned char TPSC:3;       /*    TPSC      */
                            }      BIT;                 /*              */
                     }          TCR;                    /*              */
               union {                                  /* TMDR         */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char    :2;        /*              */
                            unsigned char BFB:1;        /*    BFB       */
                            unsigned char BFA:1;        /*    BFA       */
                            unsigned char MD :4;        /*    MD        */
                            }      BIT;                 /*              */
                     }          TMDR;                   /*              */
               union {                                  /* TIOR         */
                     unsigned int WORD;                 /*  Word Access */
                     struct {                           /*  Byte Access */
                            unsigned char H;            /*    TIORH     */
                            unsigned char L;            /*    TIORL     */
                            }     BYTE;                 /*              */
                     struct {                           /*  Bit  Access */
                            unsigned char IOB:4;        /*    IOB       */
                            unsigned char IOA:4;        /*    IOA       */
                            unsigned char IOD:4;        /*    IOD       */
                            unsigned char IOC:4;        /*    IOC       */
                            }     BIT;                  /*              */
                     }          TIOR;                   /*              */
               union {                                  /* TIER         */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char TTGE :1;      /*    TTGE      */
                            unsigned char      :2;      /*              */
                            unsigned char TCIEV:1;      /*    TCIEV     */
                            unsigned char TGIED:1;      /*    TGIED     */
                            unsigned char TGIEC:1;      /*    TGIEC     */
                            unsigned char TGIEB:1;      /*    TGIEB     */
                            unsigned char TGIEA:1;      /*    TGIEA     */
                            }      BIT;                 /*              */
                     }          TIER;                   /*              */
               union {                                  /* TSR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char     :3;       /*              */
                            unsigned char TCFV:1;       /*    TCFV      */
                            unsigned char TGFD:1;       /*    TGFD      */
                            unsigned char TGFC:1;       /*    TGFC      */
                            unsigned char TGFB:1;       /*    TGFB      */
                            unsigned char TGFA:1;       /*    TGFA      */
                            }      BIT;                 /*              */
                     }          TSR;                    /*              */
               unsigned int     TCNT;                   /* TCNT         */
               unsigned int     TGRA;                   /* TGRA         */
               unsigned int     TGRB;                   /* TGRB         */
               unsigned int     TGRC;                   /* TGRC         */
               unsigned int     TGRD;                   /* TGRD         */
};                                                      /*              */
struct st_tpu1 {                                        /* struct TPU1  */
               union {                                  /* TCR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char     :1;       /*              */
                            unsigned char CCLR:2;       /*    CCLR      */
                            unsigned char CKEG:2;       /*    CKEG      */
                            unsigned char TPSC:3;       /*    TPSC      */
                            }      BIT;                 /*              */
                     }          TCR;                    /*              */
               union {                                  /* TMDR         */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char   :4;         /*              */
                            unsigned char MD:4;         /*    MD        */
                            }      BIT;                 /*              */
                     }          TMDR;                   /*              */
               union {                                  /* TIOR         */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char IOB:4;        /*    IOB       */
                            unsigned char IOA:4;        /*    IOA       */
                            }      BIT;                 /*              */
                     }          TIOR;                   /*              */
               char             wk;                     /*              */
               union {                                  /* TIER         */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char TTGE :1;      /*    TTGE      */
                            unsigned char      :1;      /*              */
                            unsigned char TCIEU:1;      /*    TCIEU     */
                            unsigned char TCIEV:1;      /*    TCIEV     */
                            unsigned char      :2;      /*              */
                            unsigned char TGIEB:1;      /*    TGIEB     */
                            unsigned char TGIEA:1;      /*    TGIEA     */
                            }      BIT;                 /*              */
                     }          TIER;                   /*              */
               union {                                  /* TSR          */
                     unsigned char BYTE;                /*  Byte Access */
                     struct {                           /*  Bit  Access */
                            unsigned char TCFD:1;       /*    TCFD      */
                            unsigned char     :1;       /*              */
                            unsigned char TCFU:1;       /*    TCFU      */
                            unsigned char TCFV:1;       /*    TCFV      */
                            unsigned char     :2;       /*              */
                            unsigned char TGFB:1;       /*    TGFB      */
                            unsigned char TGFA:1;       /*    TGFA      */
                            }      BIT;                 /*              */
                     }          TSR;                    /*              */
               unsigned int     TCNT;                   /* TCNT         */
               unsigned int     TGRA;                   /* TGRA         */
               unsigned int     TGRB;                   /* TGRB         */
};                                                      /*              */
#define HCAN    (*(volatile struct st_hcan  *)0xFFEA00) /* HCAN  Address*/
#define SSU0    (*(volatile struct st_ssu   *)0xFFF200) /* SSU0  Address*/
#define SSU1    (*(volatile struct st_ssu   *)0xFFF210) /* SSU1  Address*/
#define SSU2    (*(volatile struct st_ssu   *)0xFFF220) /* SSU2  Address*/
#define P1      (*(volatile struct st_p1    *)0xFFFB80) /* P1    Address*/
#define P2      (*(volatile struct st_p2    *)0xFFFB81) /* P2    Address*/
#define P3      (*(volatile struct st_p3    *)0xFFFB82) /* P3    Address*/
#define P4      (*(volatile struct st_p4    *)0xFFFB93) /* P4    Address*/
#define P5      (*(volatile struct st_p5    *)0xFFFB94) /* P5    Address*/
#define P6      (*(volatile struct st_p6    *)0xFFFB85) /* P6    Address*/
#define PA      (*(volatile struct st_pa    *)0xFFFB89) /* PA    Address*/
#define PD      (*(volatile struct st_pd    *)0xFFFB8C) /* PD    Address*/
#define PH      (*(volatile struct st_ph    *)0xFFF240) /* PH    Address*/
#define PJ      (*(volatile struct st_pj    *)0xFFFBA2) /* PJ    Address*/
#define PK      (*(volatile struct st_pk    *)0xFFFBA3) /* PK    Address*/
#define PFC     (*(volatile struct st_pfc   *)0xFFFBC9) /* PFC   Address*/
#define INTC    (*(volatile struct st_intc  *)0xFFFBCE) /* INTC  Address*/
#define DMAC0   (*(volatile struct st_dmac0 *)0xFFFC00) /* DMAC0 Address*/
#define DMAC1   (*(volatile struct st_dmac1 *)0xFFFC20) /* DMAC1 Address*/
#define DMAC2   (*(volatile struct st_dmac2 *)0xFFFC40) /* DMAC2 Address*/
#define DMAC3   (*(volatile struct st_dmac3 *)0xFFFC60) /* DMAC3 Address*/
#define BSC     (*(volatile struct st_bsc   *)0xFFFD94) /* BSC   Address*/
#define MDCR    (*(volatile union  un_mdcr  *)0xFFFDC0) /* MDCR  Address*/
#define SYSCR   (*(volatile union  un_syscr *)0xFFFDC2) /* SYSCR Address*/
#define SCKCR   (*(volatile union  un_sckcr *)0xFFFDC4) /* SCKCR Address*/
#define SBYCR   (*(volatile union  un_sbycr *)0xFFFDC6) /* SBYCR Address*/
#define MSTP    (*(volatile struct st_mstp  *)0xFFFDC8) /* MSTP  Address*/
#define FLASH   (*(volatile struct st_flash *)0xFFFD9E) /* FLASH Address*/
#define PPG     (*(volatile struct st_ppg   *)0xFFFF76) /* PPG   Address*/
#define SCI3    (*(volatile struct st_sci   *)0xFFFE88) /* SCI3  Address*/
#define SCI4    (*(volatile struct st_sci   *)0xFFFE90) /* SCI4  Address*/
#define SMCI3   (*(volatile struct st_smci  *)0xFFFE88) /* SMCI3 Address*/
#define SMCI4   (*(volatile struct st_smci  *)0xFFFE90) /* SMCI4 Address*/
#define AD0     (*(volatile struct st_ad    *)0xFFFF90) /* A/D0  Address*/
#define AD1     (*(volatile struct st_ad    *)0xFFFA90) /* A/D1  Address*/
#define WDT     (*(volatile union  un_wdt   *)0xFFFFA4) /* WDT   Address*/
#define TPU     (*(volatile struct st_tpu   *)0xFFFB00) /* TPU   Address*/
#define TPU0    (*(volatile struct st_tpu0  *)0xFFFFC0) /* TPU0  Address*/
#define TPU1    (*(volatile struct st_tpu1  *)0xFFFFD0) /* TPU1  Address*/
#define TPU2    (*(volatile struct st_tpu1  *)0xFFFFE0) /* TPU2  Address*/
#define TPU3    (*(volatile struct st_tpu0  *)0xFFFFF0) /* TPU3  Address*/
#define TPU4    (*(volatile struct st_tpu1  *)0xFFFEE0) /* TPU4  Address*/
#define TPU5    (*(volatile struct st_tpu1  *)0xFFFEF0) /* TPU5  Address*/
#define TPU6    (*(volatile struct st_tpu0  *)0xFFFB10) /* TPU6  Address*/
#define TPU7    (*(volatile struct st_tpu1  *)0xFFFB20) /* TPU7  Address*/
#define TPU8    (*(volatile struct st_tpu1  *)0xFFFB30) /* TPU8  Address*/
#define TPU9    (*(volatile struct st_tpu0  *)0xFFFB40) /* TPU9  Address*/
#define TPU10   (*(volatile struct st_tpu1  *)0xFFFB50) /* TPU10 Address*/
#define TPU11   (*(volatile struct st_tpu1  *)0xFFFB60) /* TPU11 Address*/
