/* HAL-only entry function */
#include "hal_data.h"
void hal_entry(void)
{
    bsp_leds_t Leds;

    /* populate the Leds-structure with the values for the S5D9 Promotion Kit  */
    R_BSP_LedsGet(&Leds);

    while (1)
    {
        /* turn off LED1 and turn on LED3                                      */
        g_ioport.p_api->pinWrite(Leds.p_leds[BSP_LED_LED1], IOPORT_LEVEL_HIGH);
        g_ioport.p_api->pinWrite(Leds.p_leds[BSP_LED_LED3], IOPORT_LEVEL_LOW);

        /* wait for 1 second                                                   */
        R_BSP_SoftwareDelay(1, BSP_DELAY_UNITS_SECONDS);

        /* turn on LED1 and turn off LED3                                      */
        g_ioport.p_api->pinWrite(Leds.p_leds[BSP_LED_LED1], IOPORT_LEVEL_LOW);
        g_ioport.p_api->pinWrite(Leds.p_leds[BSP_LED_LED3], IOPORT_LEVEL_HIGH);

        /* wait for 1 second                                                   */
        R_BSP_SoftwareDelay(1, BSP_DELAY_UNITS_SECONDS);
    }
}
