// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*! 
 * @file TFMessage.c
 * This source file contains the definition of the described types in the IDL file.
 *
 * This file was generated by the tool gen.
 */

#include "TFMessage.h"

#include <ucdr/microcdr.h>
#include <string.h>

bool TFMessage_serialize_topic(ucdrBuffer* writer, const TFMessage* topic)
{
    for(int i = 0; i < sizeof(topic->transforms) / sizeof(TransformStamped); ++i)
    {
        (void) TransformStamped_serialize_topic(writer, &topic->transforms[i]);
    }    return !writer->error;
}

bool TFMessage_deserialize_topic(ucdrBuffer* reader, TFMessage* topic)
{
    for(int i = 0; i < sizeof(topic->transforms) / sizeof(TransformStamped); ++i)
    {
        (void) TransformStamped_deserialize_topic(reader, &topic->transforms[i]);
    }    return !reader->error;
}

uint32_t TFMessage_size_of_topic(const TFMessage* topic, uint32_t size)
{
    uint32_t previousSize = size;
    for(int i = 0; i < sizeof(topic->transforms) / sizeof(TransformStamped); ++i)
    {
        size += TransformStamped_size_of_topic(&topic->transforms[i], size);
    }    return size - previousSize;
}
